### ant-design-pro 2.x踩坑手记 ###

- 编译时控制台报错代码如下：
```javascript
[hardsource:f5ffae14] Could not freeze ./node_modules/css-hot-loader/hotModuleReplacement.js: Cannot read property 'hash' of undefined
[hardsource:f5ffae14] Could not freeze ./node_modules/debug/src/browser.js: Cannot read property 'hash' of undefined
[hardsource:f5ffae14] Could not freeze ./node_modules/debug/src/debug.js: Cannot read property 'hash' of undefined
[hardsource:f5ffae14] Could not freeze ./node_modules/dva-immer/lib/index.js: Cannot read property 'hash' of undefined
[hardsource:f5ffae14] Could not freeze ./node_modules/dva-immer/node_modules/@babel/runtime/helpers/interopRequireDefault.js: Cannot read property 'hash' of undefined
```
    **解决方案**: hardSource 的问题，删除 ./node_modules/.cache 后重启。

- 共用模块一定要写入/src/models下，不能放入/pages/XXX/models，hash打包时会有相邻模块打包不到一起问题

### 自定义目录需做以下处理（绕过国际化）：
1. src/components/PageHeaderWrapper/index.js
```javascript
           key="pageheader"
           {...restProps}
           linkElement={Link}
 -          itemRender={item => {
 -            if (item.locale) {
 -              return <FormattedMessage id={item.locale} defaultMessage={item.name} />;
 -            }
 -            return item.name;
 -          }}
 +          itemRender={item => item.name}
         />
       )}
     </MenuContext.Consumer>
```
2. src/layouts/BasicLayout.js

```javascript
       const result = {
         ...item,
 -        name: formatMessage({ id: locale, defaultMessage: item.name }),
 +        // name: formatMessage({ id: locale, defaultMessage: item.name }),
         locale,
         authority: item.authority || parentAuthority,
       };

```