# 分支开发规范

### master分支

* 大部分项目都不要直接在master下直接开发
* master分支需要确保是完全同步线上的状态， 任何时间点打包master分支都可以直接上线

### 分支创建规范

* `feature/xxx`:  新需求，功能性开发
* `hotfix/xxx`: bug修复

### 分支生命周期

* 分支上线前merge master, 上线后第一时间将分支合并入master
* 分支开发完成并合入master之后, 说明该分支生命周期已经完结，请删除分支

### 关于删除分支

* 方法一： gitlab中删除
* 方法二： 命令行执行`git push origin --delete [branch_name]`

### 分支删除后本地查看仍然可以看到

* 方法一： sourcetree pull/fetch操作时有个选项，勾选同步远程分支
* 方法二： 命令行执行`git remote prune origin` 
* 方法三: 任意分支下执行`git pull -p`

### 日志

* 严禁使用空日志提交项目
* 不要使用没有任何内容的日志， 比如 'up' 'update' '更新' 'nomessage' 等等
* 日志体现相关项目及改动内容
