gitlab-ci配置:

以下配置可以给所有antd-pro后端项目用

```yml
stages:
  - build
  - deploy
  
# 编译
build:
  stage: build
  cache:
    key: "$CI_PROJECT_NAME"
    paths:
    - node_modules/
  tags:
    - manager
  artifacts:
   name: "$CI_BUILD_REF_NAME"
   expire_in: 2 week
   paths:
    - dist/
  before_script:
    - yarn config set registry $NPM_REGISTRY
    - yarn
  script:
   - yarn run build
   - mv dist $CI_PROJECT_NAME && mkdir dist && mv $CI_PROJECT_NAME dist
  only:
    - master
    

# 部署
deploy:
  stage: deploy
  tags:
    - crm
  script:
   - fe-deploy
   - fe-refresh http://$CDN_HOST/$CI_PROJECT_NAME/
  only:
    - master  

```

### 环境变量说明:
* $CI_PROJECT_NAME: 仓库名称
* $CI_BUILD_REF_NAME: 分支名称
* $NPM_REGISTRY/$CDN_HOST都在gitlab管理界面fe组的配置里指定

### tags
指定哪一个runner进程执行ci,gitlab管理界面fe组中配置的runner

### only
一般设置只在master分支执行ci构建