# 环境搭建 LIST

### 特性

#####可选的静态类型
#####枚举、接口和类
#####命名空间
#####模块
#####Lambda表达式
#####编译时类型检查
在2013年6月微软正式发布了0.9版。之后在不断更新的过程中逐渐支持ECMAScript 2015（ES6）标准。

###环境准备

#####安装Node.js
安装文件下载地址：Node.js Downloads。TypeScript源码需要进行编译以后才能运行，Node.js提供了编译环境。
#####安装TypeScript编译工具

安装好Node.js后，打开cmd窗口，输入以下命令

npm install -g typescript

使用npm包管理工具下载TypeScript包并在全局环境下安装，安装成功后就可以通过 tsc 命令编译TypeScript源码。
可以通过 tsc -v 命令查看当前TypeScript版本。

###开发
主要包括但不限于以下几个目录和文件

/ts：TypeScript源码文件存放的文件夹

/js：编译之后生成的JavaScript文件存放的文件夹

tsconfig.json：TypeScript编译配置文件

#####tsconfig.json
```javascript
{
    "compilerOptions": {
        "target": "es5",
        "noImplicitAny": false,
        "module": "commonjs",
        "removeComments": true,
        "sourceMap": false,
        "outDir": "js"
    },
    "include":[
        "ts"
    ],
    "exclude": [
        "js"
    ]
}
```
有几个重要的属性需要解释一下：

target：编译之后生成的JavaScript文件需要遵循的标准。有三个候选项：es3、es5、es2015。
noImplicitAny：为false时，如果编译器无法根据变量的使用来判断类型时，将用any类型代替。为true时，将进行强类型检查，无法推断类型时，提示错误。
module：遵循的JavaScript模块规范。主要的候选项有：commonjs、AMD和es2015。为了后面与node.js保持一致，我们这里选用commonjs。
removeComments：编译生成的JavaScript文件是否移除注释。
sourceMap：编译时是否生成对应的source map文件。这个文件主要用于前端调试。当前端js文件被压缩引用后，出错时可借助同名的source map文件查找源文件中错误位置。
outDir：编译输出JavaScript文件存放的文件夹。
include、exclude：编译时需要包含/剔除的文件夹。


#####添加Demo源文件
在ts文件夹添加 app.ts 和 demo.ts 两个源文件

##### Demo.ts
```javascript
/**
 * Demo
 */
class Demo {
    a: number;
    b: number;

    constructor(a: number, b: number) {
        this.a = a;
        this.b = b;
    }

    sum(): number {
        return this.a + this.b;
    }
}

export {Demo};


```
##### app.ts
```javascript
/**
 * app.ts
 */
import {Demo} from './models/demo';
const demo = new Demo(1, 2);
console.log(demo.sum());
```

###配置编译和调试文件
在.vscode里添加tasks.json文件

```javascript
{
    // See https://go.microsoft.com/fwlink/?LinkId=733558
    // for the documentation about the tasks.json format
    "version": "0.1.0",
    "command": "tsc",
    "isShellCommand": true,
    "args": ["-p", "."],
    "showOutput": "always",
    "problemMatcher": "$tsc"
}
```
修改生成的launch.json文件内容，指定启动入口文件的路径
```javascript
{
    "version": "0.2.0",
    "configurations": [
        {
            "name": "启动",
            "type": "node",
            "request": "launch",
            "program": "${workspaceRoot}/js/app.js",
            "stopOnEntry": false,
            "args": [],
            "cwd": "${workspaceRoot}",
            "preLaunchTask": null,
            "runtimeExecutable": null,
            "runtimeArgs": [
                "--nolazy"
            ],
            "env": {
                "NODE_ENV": "development"
            },
            "externalConsole": false,
            "sourceMaps": false,
            "outDir": null
        },
    ]
}
```
以上配置完成后，使用 Ctrl+Shift+B 启动编译，如果VS Code的OUTPUT窗口没有任何异常信息显示，则表示编译成功。在js文件夹里将会生成编译后的JavaScript文件

#####demo.js
```javascript
"use strict";
var Demo = (function () {
    function Demo(a, b) {
        this.a = a;
        this.b = b;
    }
    Demo.prototype.sum = function () {
        return this.a + this.b;
    };
    return Demo;
}());
exports.Demo = Demo;
```
#####app.js
```javascript
"use strict";
var demo_1 = require('./models/demo');
var demo = new demo_1.Demo(1, 2);
console.log(demo.sum());
```