## webpack练习

* Entry: 入口

类型|例子|含义
- | :- | :-
string|'./app/entry'|入口模块的文件路径，可以是相对路径
array|['./app/entrye','./app/entry2']|入口模块的文件路径，可以是相对路径
object|{a:'./app/entrye-a',b:['./app/entryb1','./app/entryb2']}|配置多个入口，每个入口生成一个Chunk

* Module: 模块，在Webpack里一切皆模块，一个模块对应一个文件。Webpack会从配置的Entry开始递归找到所有以来的模块。
* Chunk: 代码块，一个Chunk由多个模块组合而成，用于代码合并和分割。
* Loader: 模块转换器，用于将模块的原内容按照需求转换成新内容。
* Plugin: 扩展插件，在Webpack构建流程中的特定时机注入扩展逻辑，来改变构建结果或做我们想要的事情。
* Output: 输出结果

内置变量列表

变量名|含义
- | :- 
id|Chunk的唯一表识别，从0开始
name|Chunk的名称
hash|Chunk的唯一表识别，Hash值
chunkhash|Chunk内容的Hash值

hash和chunkhash的长度是可以制定的，[hash:8]代表取8位值，默认是20位


--------------------------
### 通常我们可用如下经验去判断如何配置webpack

* 若想让源文件加入构建流程中被Webpack控制，则配置 entry
* 若想自定义输出文件的位置和名称，则配置output
* 若想自定义寻找依赖模块时的策略，则配置resolve
* 若想自定义解析和转换文件的策略，则配置module，通常是配置module.rules里的Loader
* 若其他大部分需求可能通过Plugin去实现，则配置plugin


---------------------------
### webpack4提供了mode

配置中设置
```javascript
module.exports = {
  mode: 'production'
};
```
cli参数中传递
```javascript
webpack --mode=production
```

选项|描述
- | :- 
development|会将 process.env.NODE_ENV 的值设为 development。启用 NamedChunksPlugin 和 NamedModulesPlugin。
production|会将 process.env.NODE_ENV 的值设为 production。启用 FlagDependencyUsagePlugin, FlagIncludedChunksPlugin, ModuleConcatenationPlugin, NoEmitOnErrorsPlugin, OccurrenceOrderPlugin, SideEffectsFlagPlugin 和 UglifyJsPlugin.