import api from '../../api';

const { GET_LIST_SUCC } = require('../actionTypes').default;

function getLoanListSucc(payload) {
  return {
    type: GET_LIST_SUCC,
    payload
  };
}

export function getLongAuctionList(params) {
  return async (dispatch) => {
    try {
      const res = await api.getListData();
      const resJson = await res.json();
      if (resJson.code === 0) {
        dispatch(getLoanListSucc(resJson.data.record));
      }
    } catch (err) {
      console.warn(err);
    }
  };
}
