import { bindActionCreators } from 'redux';
import { connect } from 'react-redux';
import React, { Component } from 'react';
import {
  Dimensions,
  StyleSheet,
  View,
  FlatList,
} from 'react-native';
import { Map } from 'immutable';

import MarketListItem from '../../components/market-list-item';
import * as auctionActions from '../../reducers/auction/auctionActions';

const Screen = Dimensions.get('window');

class Market extends Component {
  constructor(props, context) {
    super(props);
    this.state = {
      refreshState: false,
    };
    this.refreshData = this.refreshData.bind(this);
  }

  componentWillMount() {
    this.props.actions.getLongAuctionList();
  }

  refreshData() {
    this.setState({ refreshState: true });
    setTimeout(() => {
      this.setState({ refreshState: false });
    }, 1000);
  }


  render() {
    const { listData } = this.props.auction;

    return (
      <View style={styles.container}>
        <FlatList
          data={listData}
          onRefresh={this.refreshData}
          refreshing={this.state.refreshState}
          renderItem={({ item }) => <MarketListItem item={item} />}
        />
      </View>
    );
  }
}

const actions = [
  auctionActions
];

function mapStateToProps(state) {
  return {
    auction: state.auction.toJS(),
  };
}

function mapDispatchToProps(dispatch) {
  const creators = Map()
    .merge(...actions)
    .filter(value => typeof value === 'function')
    .toObject();

  return {
    actions: bindActionCreators(creators, dispatch),
    dispatch
  };
}

export default connect(mapStateToProps, mapDispatchToProps)(Market);

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: '#ffffff'
  },
  webviewWrap: {
    width: Screen.width,
    height: Screen.height
  }
});
