import { connect } from 'react-redux';
import React, { Component } from 'react';
import {
  View,
  StyleSheet,
  Platform
} from 'react-native';

import CommonForm from '../../components/common-form';

class Account extends Component {
  constructor(props, context) {
    super(props);
  }

  goPage(page) {
    this.props.navigation.navigate(page);
  }

  render() {
    const myFormCfg = {
      fields: {
        feedback: {
          type: 'routeInput',
          iconSource: '',
          label: '意见反馈',
          onNext: this.goPage.bind(this, 'Login')
        },
        setting: {
          type: 'routeInput',
          iconSource: '',
          label: '设置',
          onNext: this.goPage.bind(this, 'Setting')
        }
      }
    };

    return (
      <View style={{ flex: 1 }} >
        <CommonForm
          formConfig={myFormCfg}
          style={{ paddingTop: 15, paddingBottom: 0 }}
        />
      </View>
    );
  }
}

function mapStateToProps(state) {
  return {
    ...state
  };
}

function mapDispatchToProps(dispatch) {
  return {
    dispatch
  };
}

export default connect(mapStateToProps, mapDispatchToProps)(Account);
