const HOST = 'http://localhost:3600/api/';
const DEV = 'http://192.168.155.56'; // 开发环境
const TEST = 'http://192.168.155.26'; // 测试环境
const PRE = 'http://test.biz.taoche.com'; // 预发布环境
const PROD = 'https://h5-biz.taoche.com'; // 生产环境

function _apiFetch(url, params, headers, method = 'GET') {
  return fetch(`${TEST}${url}`, {
    headers: Object.assign({
      'Content-Type': 'application/json',
      'Cache-Control': 'no-cache',
      'x-access-token': 'd2de6bf1-6f29-4a8d-9bb3-d96789c3fd97'
    }, headers),
    method,
    body: JSON.stringify(params)
  });
}

function _authFetch(config) {
  const uri = config.uri;
  const accesstoken = config.accessToken;
  const method = config.method;
  const params = config.params;
  return _apiFetch(uri, params, { accesstoken }, method);
}

export default {
  getListData(params) {
    return _apiFetch('/v1/license-certificate/query', {}, {}, 'POST');
  },
};
