// 导入koa,在koa2.x版本中，导入的是一个class
const Koa = require('koa')

const bodyParser = require('koa-bodyparser');
const cors = require('koa2-cors');

const routes = require('./routes');
const { restify } = require('./rest');
const { port } = require('./config');

const app = new Koa();

app.use(cors());
app.use(bodyParser());
app.use(async (ctx, next) => {
    console.log(`${ctx.request.method} ${ctx.request.url}...`);
    await next();
});

app.use(restify());
app.use(routes());

app.listen(port || 3600);
console.log('server start at http://localhost:3600/');
