const fs = require('fs')
const path = require('path')
const chalk = require('chalk')
const logSymbols = require('log-symbols')
const execSync = require('child_process').execSync

const gitPath = path.join(process.cwd(), process.env.HUSKY_GIT_PARAMS);
const mergeMsgPath = path.join(gitPath,'../','MERGE_MSG')

function mergeCheck(){
    console.log(logSymbols.info, chalk.blue('开始分支检测...'))
    const mergeMsg = fs.readFileSync(mergeMsgPath, 'utf-8');
    let curBranch = execSync("git symbolic-ref HEAD | sed -e \'s,.*/\(.*\),\1,\'", {encoding: 'utf-8'})

    console.log('curBranch', curBranch)
    console.log('mergeBranch' ,mergeMsg.match(/\"(.*?)\"/g))
    process.exit(1)
}

function commitMsgCheck(){
    console.log(logSymbols.info, chalk.blue('开始commit检测...'))
    const commitMsg = fs.readFileSync(gitPath, 'utf-8');
    if(!commitMsg || commitMsg.indexOf('no message')>=0) {
        console.log(logSymbols.error, chalk.red('no message'))
        process.exit(1)
    }
}

function conflictCheck() {
    console.log(logSymbols.info, chalk.blue('开始冲突检测...'))

    // git 对所有冲突的地方都会生成下面这种格式的信息，所以写个检测冲突文件的正则
    const isConflictRegular = "^<<<<<<<\\s|^=======$|^>>>>>>>\\s"
    
    let results
    
    try {
        // git grep 命令会执行 perl 的正则匹配所有满足冲突条件的文件
        results = execSync(`git grep -n -P "${isConflictRegular}"`, {encoding: 'utf-8'})
    } catch (e) {
        process.exit(0)
    }
    
    if(results) {
        console.log(logSymbols.error, chalk.red('发现冲突，请解决后再提交，冲突文件：'))
        console.log(results.trim())
        process.exit(1)
    }    
}

if(fs.existsSync(mergeMsgPath)){
    mergeCheck()
} else {
    commitMsgCheck()    
}

conflictCheck()

process.exit(0)