module.exports = {
  /*
  ** Headers of the page
  */
  head: {
    title: '北京天绿恒力科技有限公司',
    meta: [
      { charset: 'utf-8' },
      { name: 'viewport', content: 'width=device-width, initial-scale=1' },
      { hid: 'description', name: 'description', content: '北京天绿恒力科技有限公司' }
    ],
    link: [
      { rel: 'icon', type: 'image/x-icon', href: '/favicon.ico' }
    ]
  },
  css: [
    // 'element-ui/lib/theme-chalk/index.css'
    'quill/dist/quill.core.css',
    'quill/dist/quill.snow.css',
    'quill/dist/quill.bubble.css',
    'normalize.css/normalize.css',
    '~assets/css/common.scss'
  ],

  modules: [
    '@nuxtjs/axios',
    '@nuxtjs/proxy'
  ],
  plugins:[
    '@/plugins/element-ui',
    { src: '@/plugins/nuxt-quill-plugin.js', ssr: false },
    { src: '@/plugins/vue-seamless-scroll.js', ssr: false },
  ],
  // proxy: [
  //   ['/api', { target: 'https://dog.ceo/'}], 
  // ],
  /*
  ** Customize the progress bar color
  */
  loading: { color: '#73A7E1' },
  /*
  ** Build configuration
  */
  build: {
    vendor: [
    ],
    babel:{
      plugins: [['component', [
        {
          'libraryName': 'element-ui',
          'styleLibraryName': 'theme-chalk',
        },
        'transform-async-to-generator',
        'transform-runtime'
      ]]],
      comments: false
    },
    /*
    ** Run ESLint on save
    */
    extend (config, { isDev, isClient }) {
      if (isDev && isClient) {
        config.module.rules.push({
          enforce: 'pre',
          test: /\.(js|vue)$/,
          loader: 'eslint-loader',
          exclude: /(node_modules)/
        })
      }
    }
  }
}

